/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.h2.api.IntervalQualifier;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueInterval;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class LocalDateTimeUtils {
    public static final Class<?> LOCAL_DATE = LocalDateTimeUtils.tryGetClass("java.time.LocalDate");
    public static final Class<?> LOCAL_TIME = LocalDateTimeUtils.tryGetClass("java.time.LocalTime");
    public static final Class<?> LOCAL_DATE_TIME = LocalDateTimeUtils.tryGetClass("java.time.LocalDateTime");
    public static final Class<?> INSTANT = LocalDateTimeUtils.tryGetClass("java.time.Instant");
    public static final Class<?> OFFSET_DATE_TIME = LocalDateTimeUtils.tryGetClass("java.time.OffsetDateTime");
    private static final Class<?> ZONE_OFFSET = LocalDateTimeUtils.tryGetClass("java.time.ZoneOffset");
    public static final Class<?> PERIOD = LocalDateTimeUtils.tryGetClass("java.time.Period");
    public static final Class<?> DURATION = LocalDateTimeUtils.tryGetClass("java.time.Duration");
    private static final Method LOCAL_TIME_OF_NANO;
    private static final Method LOCAL_TIME_TO_NANO;
    private static final Method LOCAL_DATE_OF_YEAR_MONTH_DAY;
    private static final Method LOCAL_DATE_GET_YEAR;
    private static final Method LOCAL_DATE_GET_MONTH_VALUE;
    private static final Method LOCAL_DATE_GET_DAY_OF_MONTH;
    private static final Method LOCAL_DATE_AT_START_OF_DAY;
    private static final Method INSTANT_GET_EPOCH_SECOND;
    private static final Method INSTANT_GET_NANO;
    private static final Method TIMESTAMP_TO_INSTANT;
    private static final Method LOCAL_DATE_TIME_PLUS_NANOS;
    private static final Method LOCAL_DATE_TIME_TO_LOCAL_DATE;
    private static final Method LOCAL_DATE_TIME_TO_LOCAL_TIME;
    private static final Method ZONE_OFFSET_OF_TOTAL_SECONDS;
    private static final Method OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET;
    private static final Method OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME;
    private static final Method OFFSET_DATE_TIME_GET_OFFSET;
    private static final Method ZONE_OFFSET_GET_TOTAL_SECONDS;
    private static final Method PERIOD_OF;
    private static final Method PERIOD_GET_YEARS;
    private static final Method PERIOD_GET_MONTHS;
    private static final Method PERIOD_GET_DAYS;
    private static final Method DURATION_OF_SECONDS;
    private static final Method DURATION_GET_SECONDS;
    private static final Method DURATION_GET_NANO;
    private static final boolean IS_JAVA8_DATE_API_PRESENT;

    private LocalDateTimeUtils() {
    }

    public static boolean isJava8DateApiPresent() {
        return IS_JAVA8_DATE_API_PRESENT;
    }

    private static Class<?> tryGetClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("Java 8 or later but method " + clazz.getName() + "#" + string + "(" + Arrays.toString(classArray) + ") is missing", noSuchMethodException);
        }
    }

    public static Object valueToLocalDate(Value value) {
        try {
            return LocalDateTimeUtils.localDateFromDateValue(((ValueDate)value.convertTo(10)).getDateValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "date conversion failed");
        }
    }

    public static Object valueToLocalTime(Value value) {
        try {
            return LOCAL_TIME_OF_NANO.invoke(null, ((ValueTime)value.convertTo(9)).getNanos());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "time conversion failed");
        }
    }

    public static Object valueToLocalDateTime(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l = valueTimestamp.getDateValue();
        long l2 = valueTimestamp.getTimeNanos();
        try {
            return LocalDateTimeUtils.localDateTimeFromDateNanos(l, l2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "timestamp conversion failed");
        }
    }

    public static Object valueToInstant(Value value) {
        try {
            return TIMESTAMP_TO_INSTANT.invoke((Object)value.getTimestamp(), new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "timestamp conversion failed");
        }
    }

    public static Object valueToOffsetDateTime(Value value) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value.convertTo(24);
        long l = valueTimestampTimeZone.getDateValue();
        long l2 = valueTimestampTimeZone.getTimeNanos();
        try {
            Object object = LocalDateTimeUtils.localDateTimeFromDateNanos(l, l2);
            short s2 = valueTimestampTimeZone.getTimeZoneOffsetMins();
            int n = (int)TimeUnit.MINUTES.toSeconds(s2);
            Object object2 = ZONE_OFFSET_OF_TOTAL_SECONDS.invoke(null, n);
            return OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET.invoke(null, object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "timestamp with time zone conversion failed");
        }
    }

    public static Object valueToPeriod(Value value) {
        if (!(value instanceof ValueInterval)) {
            value = value.convertTo(32);
        }
        if (!DataType.isYearMonthIntervalType(value.getValueType())) {
            throw DbException.get(22018, (Throwable)null, value.getString());
        }
        ValueInterval valueInterval = (ValueInterval)value;
        IntervalQualifier intervalQualifier = valueInterval.getQualifier();
        boolean bl = valueInterval.isNegative();
        long l = valueInterval.getLeading();
        long l2 = valueInterval.getRemaining();
        int n = Value.convertToInt(IntervalUtils.yearsFromInterval(intervalQualifier, bl, l, l2), null);
        int n2 = Value.convertToInt(IntervalUtils.monthsFromInterval(intervalQualifier, bl, l, l2), null);
        try {
            return PERIOD_OF.invoke(null, n, n2, 0);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "timestamp with time zone conversion failed");
        }
    }

    public static Object valueToDuration(Value value) {
        if (!(value instanceof ValueInterval)) {
            value = value.convertTo(35);
        }
        if (DataType.isYearMonthIntervalType(value.getValueType())) {
            throw DbException.get(22018, (Throwable)null, value.getString());
        }
        BigInteger[] bigIntegerArray = IntervalUtils.intervalToAbsolute((ValueInterval)value).divideAndRemainder(BigInteger.valueOf(1000000000L));
        try {
            return DURATION_OF_SECONDS.invoke(null, bigIntegerArray[0].longValue(), bigIntegerArray[1].longValue());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "timestamp with time zone conversion failed");
        }
    }

    public static Value localDateToDateValue(Object object) {
        try {
            return ValueDate.fromDateValue(LocalDateTimeUtils.dateValueFromLocalDate(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "date conversion failed");
        }
    }

    public static Value localTimeToTimeValue(Object object) {
        try {
            return ValueTime.fromNanos((Long)LOCAL_TIME_TO_NANO.invoke(object, new Object[0]));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "time conversion failed");
        }
    }

    public static Value localDateTimeToValue(Object object) {
        try {
            Object object2 = LOCAL_DATE_TIME_TO_LOCAL_DATE.invoke(object, new Object[0]);
            long l = LocalDateTimeUtils.dateValueFromLocalDate(object2);
            long l2 = LocalDateTimeUtils.timeNanosFromLocalDateTime(object);
            return ValueTimestamp.fromDateValueAndNanos(l, l2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "local date time conversion failed");
        }
    }

    public static Value instantToValue(Object object) {
        try {
            long l = (Long)INSTANT_GET_EPOCH_SECOND.invoke(object, new Object[0]);
            int n = (Integer)INSTANT_GET_NANO.invoke(object, new Object[0]);
            long l2 = l / 86400L;
            if (l < 0L && l2 * 86400L != l) {
                --l2;
            }
            long l3 = (l - l2 * 86400L) * 1000000000L + (long)n;
            return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l2), l3, (short)0);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "instant conversion failed");
        }
    }

    public static ValueTimestampTimeZone offsetDateTimeToValue(Object object) {
        try {
            Object object2 = OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME.invoke(object, new Object[0]);
            Object object3 = LOCAL_DATE_TIME_TO_LOCAL_DATE.invoke(object2, new Object[0]);
            Object object4 = OFFSET_DATE_TIME_GET_OFFSET.invoke(object, new Object[0]);
            long l = LocalDateTimeUtils.dateValueFromLocalDate(object3);
            long l2 = LocalDateTimeUtils.timeNanosFromLocalDateTime(object2);
            short s2 = LocalDateTimeUtils.zoneOffsetToOffsetMinute(object4);
            return ValueTimestampTimeZone.fromDateValueAndNanos(l, l2, s2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "time conversion failed");
        }
    }

    private static long dateValueFromLocalDate(Object object) throws IllegalAccessException, InvocationTargetException {
        int n = (Integer)LOCAL_DATE_GET_YEAR.invoke(object, new Object[0]);
        int n2 = (Integer)LOCAL_DATE_GET_MONTH_VALUE.invoke(object, new Object[0]);
        int n3 = (Integer)LOCAL_DATE_GET_DAY_OF_MONTH.invoke(object, new Object[0]);
        return DateTimeUtils.dateValue(n, n2, n3);
    }

    private static long timeNanosFromLocalDateTime(Object object) throws IllegalAccessException, InvocationTargetException {
        Object object2 = LOCAL_DATE_TIME_TO_LOCAL_TIME.invoke(object, new Object[0]);
        return (Long)LOCAL_TIME_TO_NANO.invoke(object2, new Object[0]);
    }

    private static short zoneOffsetToOffsetMinute(Object object) throws IllegalAccessException, InvocationTargetException {
        int n = (Integer)ZONE_OFFSET_GET_TOTAL_SECONDS.invoke(object, new Object[0]);
        return (short)TimeUnit.SECONDS.toMinutes(n);
    }

    private static Object localDateFromDateValue(long l) throws IllegalAccessException, InvocationTargetException {
        int n = DateTimeUtils.yearFromDateValue(l);
        int n2 = DateTimeUtils.monthFromDateValue(l);
        int n3 = DateTimeUtils.dayFromDateValue(l);
        try {
            return LOCAL_DATE_OF_YEAR_MONTH_DAY.invoke(null, n, n2, n3);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (n <= 1500 && (n & 3) == 0 && n2 == 2 && n3 == 29) {
                return LOCAL_DATE_OF_YEAR_MONTH_DAY.invoke(null, n, 3, 1);
            }
            throw invocationTargetException;
        }
    }

    private static Object localDateTimeFromDateNanos(long l, long l2) throws IllegalAccessException, InvocationTargetException {
        Object object = LocalDateTimeUtils.localDateFromDateValue(l);
        Object object2 = LOCAL_DATE_AT_START_OF_DAY.invoke(object, new Object[0]);
        return LOCAL_DATE_TIME_PLUS_NANOS.invoke(object2, l2);
    }

    public static ValueInterval periodToValue(Object object) {
        try {
            IntervalQualifier intervalQualifier;
            int n = (Integer)PERIOD_GET_DAYS.invoke(object, new Object[0]);
            if (n != 0) {
                throw DbException.getInvalidValueException("Period.days", n);
            }
            int n2 = (Integer)PERIOD_GET_YEARS.invoke(object, new Object[0]);
            int n3 = (Integer)PERIOD_GET_MONTHS.invoke(object, new Object[0]);
            boolean bl = false;
            long l = 0L;
            long l2 = 0L;
            if (n2 == 0) {
                if ((long)n3 == 0L) {
                    intervalQualifier = IntervalQualifier.YEAR_TO_MONTH;
                } else {
                    intervalQualifier = IntervalQualifier.MONTH;
                    l = n3;
                    if (l < 0L) {
                        l = -l;
                        bl = true;
                    }
                }
            } else if ((long)n3 == 0L) {
                intervalQualifier = IntervalQualifier.YEAR;
                l = n2;
                if (l < 0L) {
                    l = -l;
                    bl = true;
                }
            } else {
                intervalQualifier = IntervalQualifier.YEAR_TO_MONTH;
                l = n2 * 12 + n3;
                if (l < 0L) {
                    l = -l;
                    bl = true;
                }
                l2 = l % 12L;
                l /= 12L;
            }
            return ValueInterval.from(intervalQualifier, bl, l, l2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "interval conversion failed");
        }
    }

    public static ValueInterval durationToValue(Object object) {
        try {
            long l = (Long)DURATION_GET_SECONDS.invoke(object, new Object[0]);
            int n = (Integer)DURATION_GET_NANO.invoke(object, new Object[0]);
            boolean bl = l < 0L;
            l = Math.abs(l);
            if (bl && n != 0) {
                n = 1000000000 - n;
                --l;
            }
            return ValueInterval.from(IntervalQualifier.SECOND, bl, l, n);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DbException.convert(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DbException.convertInvocation(invocationTargetException, "interval conversion failed");
        }
    }

    static {
        boolean bl = IS_JAVA8_DATE_API_PRESENT = LOCAL_DATE != null && LOCAL_TIME != null && LOCAL_DATE_TIME != null && INSTANT != null && OFFSET_DATE_TIME != null && ZONE_OFFSET != null && PERIOD != null && DURATION != null;
        if (IS_JAVA8_DATE_API_PRESENT) {
            LOCAL_TIME_OF_NANO = LocalDateTimeUtils.getMethod(LOCAL_TIME, "ofNanoOfDay", Long.TYPE);
            LOCAL_TIME_TO_NANO = LocalDateTimeUtils.getMethod(LOCAL_TIME, "toNanoOfDay", new Class[0]);
            LOCAL_DATE_OF_YEAR_MONTH_DAY = LocalDateTimeUtils.getMethod(LOCAL_DATE, "of", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            LOCAL_DATE_GET_YEAR = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getYear", new Class[0]);
            LOCAL_DATE_GET_MONTH_VALUE = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getMonthValue", new Class[0]);
            LOCAL_DATE_GET_DAY_OF_MONTH = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getDayOfMonth", new Class[0]);
            LOCAL_DATE_AT_START_OF_DAY = LocalDateTimeUtils.getMethod(LOCAL_DATE, "atStartOfDay", new Class[0]);
            INSTANT_GET_EPOCH_SECOND = LocalDateTimeUtils.getMethod(INSTANT, "getEpochSecond", new Class[0]);
            INSTANT_GET_NANO = LocalDateTimeUtils.getMethod(INSTANT, "getNano", new Class[0]);
            TIMESTAMP_TO_INSTANT = LocalDateTimeUtils.getMethod(Timestamp.class, "toInstant", new Class[0]);
            LOCAL_DATE_TIME_PLUS_NANOS = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "plusNanos", Long.TYPE);
            LOCAL_DATE_TIME_TO_LOCAL_DATE = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "toLocalDate", new Class[0]);
            LOCAL_DATE_TIME_TO_LOCAL_TIME = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "toLocalTime", new Class[0]);
            ZONE_OFFSET_OF_TOTAL_SECONDS = LocalDateTimeUtils.getMethod(ZONE_OFFSET, "ofTotalSeconds", Integer.TYPE);
            OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "toLocalDateTime", new Class[0]);
            OFFSET_DATE_TIME_GET_OFFSET = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "getOffset", new Class[0]);
            OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "of", LOCAL_DATE_TIME, ZONE_OFFSET);
            ZONE_OFFSET_GET_TOTAL_SECONDS = LocalDateTimeUtils.getMethod(ZONE_OFFSET, "getTotalSeconds", new Class[0]);
            PERIOD_OF = LocalDateTimeUtils.getMethod(PERIOD, "of", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            PERIOD_GET_YEARS = LocalDateTimeUtils.getMethod(PERIOD, "getYears", new Class[0]);
            PERIOD_GET_MONTHS = LocalDateTimeUtils.getMethod(PERIOD, "getMonths", new Class[0]);
            PERIOD_GET_DAYS = LocalDateTimeUtils.getMethod(PERIOD, "getDays", new Class[0]);
            DURATION_OF_SECONDS = LocalDateTimeUtils.getMethod(DURATION, "ofSeconds", Long.TYPE, Long.TYPE);
            DURATION_GET_SECONDS = LocalDateTimeUtils.getMethod(DURATION, "getSeconds", new Class[0]);
            DURATION_GET_NANO = LocalDateTimeUtils.getMethod(DURATION, "getNano", new Class[0]);
        } else {
            LOCAL_TIME_OF_NANO = null;
            LOCAL_TIME_TO_NANO = null;
            LOCAL_DATE_OF_YEAR_MONTH_DAY = null;
            LOCAL_DATE_GET_YEAR = null;
            LOCAL_DATE_GET_MONTH_VALUE = null;
            LOCAL_DATE_GET_DAY_OF_MONTH = null;
            LOCAL_DATE_AT_START_OF_DAY = null;
            INSTANT_GET_EPOCH_SECOND = null;
            INSTANT_GET_NANO = null;
            TIMESTAMP_TO_INSTANT = null;
            LOCAL_DATE_TIME_PLUS_NANOS = null;
            LOCAL_DATE_TIME_TO_LOCAL_DATE = null;
            LOCAL_DATE_TIME_TO_LOCAL_TIME = null;
            ZONE_OFFSET_OF_TOTAL_SECONDS = null;
            OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME = null;
            OFFSET_DATE_TIME_GET_OFFSET = null;
            OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET = null;
            ZONE_OFFSET_GET_TOTAL_SECONDS = null;
            PERIOD_OF = null;
            PERIOD_GET_YEARS = null;
            PERIOD_GET_MONTHS = null;
            PERIOD_GET_DAYS = null;
            DURATION_OF_SECONDS = null;
            DURATION_GET_SECONDS = null;
            DURATION_GET_NANO = null;
        }
    }
}

