/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.h2.api.IntervalQualifier;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInterval;
import org.h2.value.ValueNull;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

final class Percentile {
    static final BigDecimal HALF = BigDecimal.valueOf(0.5);

    private static boolean isNullsLast(Index index) {
        IndexColumn indexColumn = index.getIndexColumns()[0];
        int n = indexColumn.sortType;
        return (n & 4) != 0 || (n & 2) == 0 && (n & 1) != 0 ^ SysProperties.SORT_NULLS_HIGH;
    }

    static Index getColumnIndex(Expression expression) {
        if (expression instanceof ExpressionColumn) {
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            Column column = expressionColumn.getColumn();
            TableFilter tableFilter = expressionColumn.getTableFilter();
            if (tableFilter != null) {
                Table table = tableFilter.getTable();
                ArrayList<Index> arrayList = table.getIndexes();
                Index index = null;
                if (arrayList != null) {
                    boolean bl = column.isNullable();
                    int n = arrayList.size();
                    for (int i = 1; i < n; ++i) {
                        Index index2 = arrayList.get(i);
                        if (!index2.canFindNext() || !index2.isFirstColumn(column) || index != null && index.getColumns().length <= index2.getColumns().length && (!bl || !Percentile.isNullsLast(index) || Percentile.isNullsLast(index2))) continue;
                        index = index2;
                    }
                }
                return index;
            }
        }
        return null;
    }

    static Value getValue(Database database, Value[] valueArray, int n, ArrayList<SelectOrderBy> arrayList, BigDecimal bigDecimal, boolean bl) {
        int n2;
        CompareMode compareMode = database.getCompareMode();
        Arrays.sort(valueArray, compareMode);
        int n3 = valueArray.length;
        boolean bl2 = arrayList != null && (arrayList.get((int)0).sortType & 1) != 0;
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n3 - 1).multiply(bigDecimal);
        int n4 = bigDecimal2.intValue();
        BigDecimal bigDecimal3 = bigDecimal2.subtract(BigDecimal.valueOf(n4));
        if (bigDecimal3.signum() == 0) {
            bl = false;
            n2 = n4;
        } else {
            n2 = n4 + 1;
            if (!bl) {
                if (bigDecimal3.compareTo(HALF) > 0) {
                    n4 = n2;
                } else {
                    n2 = n4;
                }
            }
        }
        if (bl2) {
            n4 = n3 - 1 - n4;
            n2 = n3 - 1 - n2;
        }
        Value value = valueArray[n4];
        if (!bl) {
            return value.convertTo(n);
        }
        return Percentile.interpolate(value, valueArray[n2], bigDecimal3, n, database.getMode(), compareMode);
    }

    static Value getFromIndex(Session session, Expression expression, int n, ArrayList<SelectOrderBy> arrayList, BigDecimal bigDecimal, boolean bl) {
        long l;
        long l2;
        Object object;
        Object object2;
        boolean bl2;
        Index index = Percentile.getColumnIndex(expression);
        long l3 = index.getRowCount(session);
        if (l3 == 0L) {
            return ValueNull.INSTANCE;
        }
        Cursor cursor = index.find(session, null, null);
        cursor.next();
        int n2 = index.getColumns()[0].getColumnId();
        ExpressionColumn expressionColumn = (ExpressionColumn)expression;
        if (expressionColumn.getColumn().isNullable()) {
            bl2 = false;
            while (l3 > 0L) {
                object2 = cursor.getSearchRow();
                if (object2 == null) {
                    return ValueNull.INSTANCE;
                }
                if (object2.getValue(n2) != ValueNull.INSTANCE) break;
                --l3;
                cursor.next();
                bl2 = true;
            }
            if (l3 == 0L) {
                return ValueNull.INSTANCE;
            }
            if (!bl2 && Percentile.isNullsLast(index)) {
                TableFilter tableFilter = expressionColumn.getTableFilter();
                SearchRow searchRow = tableFilter.getTable().getTemplateSimpleRow(true);
                searchRow.setValue(n2, ValueNull.INSTANCE);
                object = index.find(session, searchRow, searchRow);
                while (object.next()) {
                    --l3;
                }
                if (l3 <= 0L) {
                    return ValueNull.INSTANCE;
                }
            }
        }
        bl2 = (arrayList != null ? arrayList.get((int)0).sortType & 1 : 0) != (index.getIndexColumns()[0].sortType & 1);
        object2 = BigDecimal.valueOf(l3 - 1L).multiply(bigDecimal);
        object = ((BigDecimal)object2).subtract(BigDecimal.valueOf(l2 = ((BigDecimal)object2).longValue()));
        if (((BigDecimal)object).signum() == 0) {
            bl = false;
            l = l2;
        } else {
            l = l2 + 1L;
            if (!bl) {
                if (((BigDecimal)object).compareTo(HALF) > 0) {
                    l2 = l;
                } else {
                    l = l2;
                }
            }
        }
        long l4 = bl2 ? l3 - 1L - l : l2;
        int n3 = 0;
        while ((long)n3 < l4) {
            cursor.next();
            ++n3;
        }
        SearchRow searchRow = cursor.getSearchRow();
        if (searchRow == null) {
            return ValueNull.INSTANCE;
        }
        Value value = searchRow.getValue(n2);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        if (bl) {
            cursor.next();
            searchRow = cursor.getSearchRow();
            if (searchRow == null) {
                return value;
            }
            Value value2 = searchRow.getValue(n2);
            if (value2 == ValueNull.INSTANCE) {
                return value;
            }
            Database database = session.getDatabase();
            if (bl2) {
                Value value3 = value;
                value = value2;
                value2 = value3;
            }
            return Percentile.interpolate(value, value2, (BigDecimal)object, n, database.getMode(), database.getCompareMode());
        }
        return value.convertTo(n);
    }

    private static Value interpolate(Value value, Value value2, BigDecimal bigDecimal, int n, Mode mode, CompareMode compareMode) {
        if (value.compareTo(value2, mode, compareMode) == 0) {
            return value.convertTo(n);
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                return ValueDecimal.get(Percentile.interpolateDecimal(BigDecimal.valueOf(value.getInt()), BigDecimal.valueOf(value2.getInt()), bigDecimal));
            }
            case 5: {
                return ValueDecimal.get(Percentile.interpolateDecimal(BigDecimal.valueOf(value.getLong()), BigDecimal.valueOf(value2.getLong()), bigDecimal));
            }
            case 6: {
                return ValueDecimal.get(Percentile.interpolateDecimal(value.getBigDecimal(), value2.getBigDecimal(), bigDecimal));
            }
            case 7: 
            case 8: {
                return ValueDecimal.get(Percentile.interpolateDecimal(BigDecimal.valueOf(value.getDouble()), BigDecimal.valueOf(value2.getDouble()), bigDecimal));
            }
            case 9: {
                ValueTime valueTime = (ValueTime)value.convertTo(9);
                ValueTime valueTime2 = (ValueTime)value2.convertTo(9);
                BigDecimal bigDecimal2 = BigDecimal.valueOf(valueTime.getNanos());
                BigDecimal bigDecimal3 = BigDecimal.valueOf(valueTime2.getNanos());
                return ValueTime.fromNanos(Percentile.interpolateDecimal(bigDecimal2, bigDecimal3, bigDecimal).longValue());
            }
            case 10: {
                ValueDate valueDate = (ValueDate)value.convertTo(10);
                ValueDate valueDate2 = (ValueDate)value2.convertTo(10);
                BigDecimal bigDecimal4 = BigDecimal.valueOf(DateTimeUtils.absoluteDayFromDateValue(valueDate.getDateValue()));
                BigDecimal bigDecimal5 = BigDecimal.valueOf(DateTimeUtils.absoluteDayFromDateValue(valueDate2.getDateValue()));
                return ValueDate.fromDateValue(DateTimeUtils.dateValueFromAbsoluteDay(Percentile.interpolateDecimal(bigDecimal4, bigDecimal5, bigDecimal).longValue()));
            }
            case 11: {
                ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
                ValueTimestamp valueTimestamp2 = (ValueTimestamp)value2.convertTo(11);
                BigDecimal bigDecimal6 = Percentile.timestampToDecimal(valueTimestamp.getDateValue(), valueTimestamp.getTimeNanos());
                BigDecimal bigDecimal7 = Percentile.timestampToDecimal(valueTimestamp2.getDateValue(), valueTimestamp2.getTimeNanos());
                BigInteger[] bigIntegerArray = Percentile.interpolateDecimal(bigDecimal6, bigDecimal7, bigDecimal).toBigInteger().divideAndRemainder(IntervalUtils.NANOS_PER_DAY_BI);
                long l = bigIntegerArray[0].longValue();
                long l2 = bigIntegerArray[1].longValue();
                if (l2 < 0L) {
                    l2 += 86400000000000L;
                    --l;
                }
                return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l), l2);
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value.convertTo(24);
                ValueTimestampTimeZone valueTimestampTimeZone2 = (ValueTimestampTimeZone)value2.convertTo(24);
                BigDecimal bigDecimal8 = Percentile.timestampToDecimal(valueTimestampTimeZone.getDateValue(), valueTimestampTimeZone.getTimeNanos());
                BigDecimal bigDecimal9 = Percentile.timestampToDecimal(valueTimestampTimeZone2.getDateValue(), valueTimestampTimeZone2.getTimeNanos());
                BigDecimal bigDecimal10 = BigDecimal.valueOf(valueTimestampTimeZone.getTimeZoneOffsetMins()).multiply(BigDecimal.ONE.subtract(bigDecimal)).add(BigDecimal.valueOf(valueTimestampTimeZone2.getTimeZoneOffsetMins()).multiply(bigDecimal));
                short s2 = bigDecimal10.shortValue();
                BigDecimal bigDecimal11 = BigDecimal.valueOf(s2);
                BigDecimal bigDecimal12 = Percentile.interpolateDecimal(bigDecimal8, bigDecimal9, bigDecimal);
                if (bigDecimal10.compareTo(bigDecimal11) != 0) {
                    bigDecimal12 = bigDecimal12.add(bigDecimal10.subtract(bigDecimal11).multiply(BigDecimal.valueOf(60000000000L)));
                }
                BigInteger[] bigIntegerArray = bigDecimal12.toBigInteger().divideAndRemainder(IntervalUtils.NANOS_PER_DAY_BI);
                long l = bigIntegerArray[0].longValue();
                long l3 = bigIntegerArray[1].longValue();
                if (l3 < 0L) {
                    l3 += 86400000000000L;
                    --l;
                }
                return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l), l3, s2);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return IntervalUtils.intervalFromAbsolute(IntervalQualifier.valueOf(n - 26), Percentile.interpolateDecimal(new BigDecimal(IntervalUtils.intervalToAbsolute((ValueInterval)value)), new BigDecimal(IntervalUtils.intervalToAbsolute((ValueInterval)value2)), bigDecimal).toBigInteger());
            }
        }
        return (bigDecimal.compareTo(HALF) > 0 ? value2 : value).convertTo(n);
    }

    private static BigDecimal timestampToDecimal(long l, long l2) {
        return new BigDecimal(BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(l)).multiply(IntervalUtils.NANOS_PER_DAY_BI).add(BigInteger.valueOf(l2)));
    }

    private static BigDecimal interpolateDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        return bigDecimal.multiply(BigDecimal.ONE.subtract(bigDecimal3)).add(bigDecimal2.multiply(bigDecimal3));
    }

    private Percentile() {
    }
}

