/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

abstract class RowTableModel<T>
extends AbstractTableModel {
    protected List<T> modelData;
    protected String[] columnNames;
    protected Class[] columnClasses;
    protected Boolean[] isColumnEditable;
    private Class rowClass = Object.class;
    private boolean isModelEditable = true;

    protected RowTableModel(Class rowClass) {
        this.setRowClass(rowClass);
    }

    protected RowTableModel(String[] columnNames) {
        this(new ArrayList(), columnNames);
    }

    protected RowTableModel(List<T> modelData, String[] columnNames) {
        this.setDataAndColumnNames(modelData, columnNames);
    }

    protected void setDataAndColumnNames(List<T> modelData, String[] columnNames) {
        this.modelData = modelData;
        this.columnNames = columnNames;
        this.columnClasses = new Class[this.getColumnCount()];
        this.isColumnEditable = new Boolean[this.getColumnCount()];
        this.fireTableStructureChanged();
    }

    protected void setRowClass(Class rowClass) {
        this.rowClass = rowClass;
    }

    public Class getColumnClass(int column) {
        Class<?> columnClass = null;
        if (column < this.columnClasses.length) {
            columnClass = this.columnClasses[column];
        }
        if (columnClass == null) {
            columnClass = super.getColumnClass(column);
        }
        return columnClass;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        Object columnName = null;
        if (column < this.columnNames.length) {
            columnName = this.columnNames[column];
        }
        return columnName == null ? super.getColumnName(column) : columnName.toString();
    }

    @Override
    public int getRowCount() {
        return this.modelData.size();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Boolean isEditable = null;
        if (column < this.isColumnEditable.length) {
            isEditable = this.isColumnEditable[column];
        }
        return isEditable == null ? this.isModelEditable : isEditable;
    }

    public void addRow(T rowData) {
        this.insertRow(this.getRowCount(), rowData);
    }

    public T getRow(int row) {
        return this.modelData.get(row);
    }

    public T[] getRowsAsArray(int ... rows) {
        List<Object> rowData = this.getRowsAsList(rows);
        Object[] array = (Object[])Array.newInstance(this.rowClass, rowData.size());
        return rowData.toArray(array);
    }

    public List<T> getRowsAsList(int ... rows) {
        ArrayList<T> rowData = new ArrayList<T>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            rowData.add(this.getRow(rows[i]));
        }
        return rowData;
    }

    public void insertRow(int row, T rowData) {
        this.modelData.add(row, rowData);
        this.fireTableRowsInserted(row, row);
    }

    public void insertRows(int row, List<T> rowList) {
        this.modelData.addAll(row, rowList);
        this.fireTableRowsInserted(row, row + rowList.size() - 1);
    }

    public void insertRows(int row, T[] rowArray) {
        ArrayList<T> rowList = new ArrayList<T>(rowArray.length);
        for (int i = 0; i < rowArray.length; ++i) {
            rowList.add(rowArray[i]);
        }
        this.insertRows(row, rowList);
    }

    public void moveRow(int start, int end, int to) {
        int last;
        int first;
        if (start < 0) {
            String message = "Start index must be positive: " + start;
            throw new IllegalArgumentException(message);
        }
        if (end > this.getRowCount() - 1) {
            String message = "End index must be less than total rows: " + end;
            throw new IllegalArgumentException(message);
        }
        if (start > end) {
            String message = "Start index cannot be greater than end index";
            throw new IllegalArgumentException(message);
        }
        int rowsMoved = end - start + 1;
        if (to < 0 || to > this.getRowCount() - rowsMoved) {
            String message = "New destination row (" + to + ") is invalid";
            throw new IllegalArgumentException(message);
        }
        ArrayList<T> temp = new ArrayList<T>(rowsMoved);
        for (int i = start; i < end + 1; ++i) {
            temp.add(this.modelData.get(i));
        }
        this.modelData.subList(start, end + 1).clear();
        this.modelData.addAll(to, temp);
        if (to < start) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        this.fireTableRowsUpdated(first, last);
    }

    public void removeRowRange(int start, int end) {
        this.modelData.subList(start, end + 1).clear();
        this.fireTableRowsDeleted(start, end);
    }

    public void removeRows(int ... rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            this.modelData.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }

    public void replaceRow(int row, T rowData) {
        this.modelData.set(row, rowData);
        this.fireTableRowsUpdated(row, row);
    }

    public void setColumnClass(int column, Class columnClass) {
        this.columnClasses[column] = columnClass;
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public void setColumnEditable(int column, boolean isEditable) {
        this.isColumnEditable[column] = isEditable ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setModelEditable(boolean isModelEditable) {
        this.isModelEditable = isModelEditable;
    }

    public static String formatColumnName(String columnName) {
        if (columnName.length() < 3) {
            return columnName;
        }
        StringBuffer buffer = new StringBuffer(columnName);
        boolean isPreviousLowerCase = false;
        for (int i = 1; i < buffer.length(); ++i) {
            boolean isCurrentUpperCase = Character.isUpperCase(buffer.charAt(i));
            if (isCurrentUpperCase && isPreviousLowerCase) {
                buffer.insert(i, " ");
                ++i;
            }
            isPreviousLowerCase = !isCurrentUpperCase;
        }
        return buffer.toString().replaceAll("_", " ");
    }
}

