/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.hubbox.hubbox_desktop_client2.Dev_Prod;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.MultivaluedMap;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class WebHelper {
    static OkHttpClient http_client;
    static MediaType jsonmedia;
    public static ObjectMapper mapper;
    public static final String subdomain;
    private static final Logger logger;

    public static void init() {
        http_client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).build();
    }

    public static Object[] checkLogin(String username, String password) throws KeyManagementException, NoSuchAlgorithmException {
        boolean result = false;
        JSONObject jo = new JSONObject();
        jo.put("username", username);
        jo.put("password", password);
        Object[] reply = WebHelper.sendPostMessage("v2/authenticate", jo.toString(), null);
        return reply;
    }

    public static Object[] sendPostMessage(String target, String request, List<String[]> headers) {
        return WebHelper.cihan_api_post("/desktopapi/" + target, headers, request);
    }

    public static Object[] sendGetMessage(String target, List<AbstractMap.SimpleEntry<String, String>> params) throws Exception {
        HttpUrl.Builder httpbuilder = HttpUrl.parse("https://" + subdomain + ".hubbox.io/desktopapi/" + target).newBuilder();
        if (params != null) {
            for (Map.Entry entry : params) {
                httpbuilder.addQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Request.Builder reqbuilder = new Request.Builder().url(httpbuilder.build()).header("Accept", "application/json").header("Content-Type", "application/json; charset=utf-8");
        Request request = reqbuilder.get().build();
        Call c = http_client.newCall(request);
        Response resp = c.execute();
        String body = resp.body().string();
        return new Object[]{resp.code(), body};
    }

    public static Object[] cihan_api(String url, List<String[]> headers, MultivaluedMap<String, String> params) {
        HttpUrl.Builder httpbuilder = HttpUrl.parse("https://" + subdomain + ".hubbox.io" + url).newBuilder();
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                httpbuilder.addQueryParameter((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
        }
        Request.Builder reqbuilder = new Request.Builder().url(httpbuilder.build()).header("Accept", "application/json").header("Content-Type", "application/json; charset=utf-8");
        if (headers != null) {
            for (String[] header : headers) {
                reqbuilder.addHeader(header[0], header[1]);
            }
        }
        Request request = reqbuilder.get().build();
        Call c = http_client.newCall(request);
        try {
            Response resp = c.execute();
            String body = resp.body().string();
            return new Object[]{resp.code(), body};
        }
        catch (IOException ex) {
            Logger.getLogger(WebHelper.class.getName()).log(Level.SEVERE, null, ex);
            return new Object[]{-1, ex.getMessage()};
        }
    }

    public static Object[] cihan_api_post(String url, List<String[]> headers, String json) {
        HttpUrl.Builder httpbuilder = HttpUrl.parse("https://" + subdomain + ".hubbox.io" + url).newBuilder();
        Request.Builder reqbuilder = new Request.Builder().url(httpbuilder.build()).header("Accept", "application/json").header("Content-Type", "application/json; charset=utf-8");
        if (headers != null) {
            for (String[] header : headers) {
                reqbuilder.addHeader(header[0], header[1]);
            }
        }
        RequestBody body = RequestBody.create(jsonmedia, json);
        Request req = reqbuilder.post(body).build();
        Call c = http_client.newCall(req);
        try {
            Response resp = c.execute();
            String respbody = resp.body().string();
            return new Object[]{resp.code(), respbody};
        }
        catch (IOException ex) {
            Logger.getLogger(WebHelper.class.getName()).log(Level.SEVERE, null, ex);
            return new Object[]{-1, ex.getMessage()};
        }
    }

    public static void test1(String[] args) {
        JSONObject jo = new JSONObject();
        while (true) {
            Object[] reply = WebHelper.sendPostMessage("login", jo.toString(), null);
            String cevap = (String)reply[1];
            int status = (Integer)reply[0];
            System.out.println(status + " " + cevap);
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(WebHelper.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    static {
        jsonmedia = MediaType.parse("application/json; charset=utf-8");
        mapper = new ObjectMapper();
        subdomain = Dev_Prod.apisubdomain;
        logger = Logger.getLogger(WebHelper.class.getName());
    }

    private static class SSLUtil {
        private SSLUtil() {
        }

        protected static SSLContext getInsecureSSLContext() throws KeyManagementException, NoSuchAlgorithmException {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            }};
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, trustAllCerts, new SecureRandom());
            return sslcontext;
        }
    }
}

