/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.helper;

import io.hubbox.hubbox_desktop_client2.helper.Konsol_Helper;
import io.hubbox.hubbox_desktop_client2.helper.PathHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;

public class UsbipHelper {
    ExecuteWatchdog wd;
    static final String path = PathHelper.getPath();
    int local_port;
    String busid;
    private static final Logger logger = Logger.getLogger(UsbipHelper.class.getName());

    public UsbipHelper(int local_port, String busid) {
        this.local_port = local_port;
        this.busid = busid;
    }

    public boolean isAlive() {
        if (this.wd != null) {
            return this.wd.isWatching();
        }
        return false;
    }

    public void baslat() {
        if (!this.isAlive()) {
            CommandLine cmdLine = CommandLine.parse(UsbipHelper.get_usb_config_path() + " --tcp-port " + this.local_port + " attach -r localhost -b " + this.busid);
            System.out.println("--starting " + cmdLine.toString());
            DefaultExecutor executor = new DefaultExecutor();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PumpStreamHandler streamHandler = new PumpStreamHandler(outputStream);
            executor.setStreamHandler(streamHandler);
            this.wd = new ExecuteWatchdog(-1L);
            executor.setWatchdog(this.wd);
            try {
                executor.execute(cmdLine, new ExecuteResultHandler(){

                    @Override
                    public void onProcessComplete(int exitValue) {
                        System.out.println("process complete " + exitValue);
                    }

                    @Override
                    public void onProcessFailed(ExecuteException e) {
                        System.out.println("process failed " + e.getMessage());
                    }
                });
            }
            catch (IOException ex) {
                Logger.getLogger(UsbipHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void stop() {
        boolean alive = this.isAlive();
        while (alive) {
            this.wd.destroyProcess();
            alive = this.isAlive();
        }
    }

    private static String get_usb_config_path() {
        return path + File.separator + "extra" + File.separator + "usb" + File.separator + "usbconnect.exe";
    }

    public static void checkDriver() {
    }

    public static boolean isDriverInstalled() {
        System.out.println(path + File.separator + "extra" + File.separator + "usb" + File.separator + "devcon64.exe status root\\usbip_vhci");
        Object[] s2 = Konsol_Helper.run_cmd_process_timeout_parsed(5, path + File.separator + "extra" + File.separator + "usb" + File.separator + "devcon64.exe status root\\usbip_vhci");
        String s3 = (String)s2[1];
        logger.info("s2 " + s2[0]);
        logger.info("s2 " + s2[1]);
        logger.info("s2 " + s2[2]);
        return s3.contains("USB/IP VHCI");
    }

    public static boolean installDriver() {
        String p2 = path + File.separator + "extra" + File.separator + "usb" + File.separator;
        String s2 = Konsol_Helper.run_cmd_process2(p2 + "devcon64.exe install " + p2 + "usbip_vhci.inf root\\usbip_vhci");
        return s2.contains("root\\usbip_vhci");
    }

    public static void main(String[] args) {
        UsbipHelper usbipHelper = new UsbipHelper(62074, "4-1");
        usbipHelper.baslat();
    }

    public static void main2(String[] args) {
        try {
            RandomAccessFile pipe = new RandomAccessFile("\\\\.\\pipe\\vhclient", "rw");
            String echoText = "MANUAL HUB LIST";
            pipe.write(echoText.getBytes());
            String sonuc = UsbipHelper.readInputStreamWithTimeout(pipe, 3000);
            System.out.println("sonuc: " + sonuc);
            pipe.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("bitti 2");
    }

    public static String readInputStreamWithTimeout(final RandomAccessFile is, final int timeoutMillis) throws IOException {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        final ArrayList result2 = new ArrayList();
        Callable<String> readTask = new Callable<String>(){

            @Override
            public String call() throws Exception {
                StringBuilder sb = new StringBuilder();
                long t1 = System.currentTimeMillis();
                try {
                    int read;
                    while ((read = is.read()) != -1) {
                        char ch = (char)read;
                        sb.append(ch);
                        result2.add(Character.valueOf(ch));
                        if (!(ch != 'e' ? ch == '>' && sb.toString().endsWith("</state>") : sb.toString().endsWith("\nVirtualHere Client not running as a service"))) {
                            if (System.currentTimeMillis() - t1 <= (long)timeoutMillis) continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return sb.toString();
            }
        };
        Future<String> future = executor.submit(readTask);
        String result = null;
        try {
            result = future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (result == null) {
            StringBuilder sb2 = new StringBuilder();
            for (Character character : result2) {
                sb2.append(character);
            }
            result = sb2.toString();
        }
        future.cancel(true);
        executor.shutdownNow();
        return result;
    }
}

