/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.jcraft.jsch.JSchException;
import io.hubbox.hubbox_desktop_client2.Dev_Prod;
import io.hubbox.hubbox_desktop_client2.HubboxGui;
import io.hubbox.hubbox_desktop_client2.helper.FabulaDesktopHelper;
import io.hubbox.hubbox_desktop_client2.helper.port.Port_Helper;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import org.json.JSONObject;

public class SocketIO_Desktop_Client {
    private Socket socket;
    ObjectMapper mapper = new ObjectMapper();
    HubboxGui gui;
    private static final Logger logger = Logger.getLogger(SocketIO_Desktop_Client.class.getName());

    public SocketIO_Desktop_Client(String token, HubboxGui gui) {
        this.gui = gui;
        IO.Options opts = new IO.Options();
        opts.secure = true;
        opts.forceNew = true;
        opts.multiplex = false;
        OkHttpClient okclient = new OkHttpClient();
        opts.callFactory = okclient;
        opts.webSocketFactory = okclient;
        opts.query = "AccessToken=" + token;
        try {
            if (Dev_Prod.apisubdomain.equals("my")) {
                this.socket = IO.socket("https://router.hubbox.io", opts);
            } else if (Dev_Prod.apisubdomain.equals("dev")) {
                this.socket = IO.socket("https://routerdev.hubbox.io", opts);
            }
            this.socket.connect();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SocketIO_Desktop_Client.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.socket.on("connect", args -> gui.notify_socket_on());
        this.socket.on("disconnect", args -> gui.notify_socket_off());
        this.socket.on("get_version_callback", args -> {
            Object obj = args[0];
            JSONObject jo = (JSONObject)obj;
            if (jo.has("sessiondata")) {
                String status;
                JSONObject content;
                JSONObject session = jo.getJSONObject("sessiondata");
                String id = session.getString("id");
                if (jo.has("content") && (content = jo.getJSONObject("content")).has("SOFTWARE_VERSION")) {
                    gui.setBoxProperty(id, "SOFTWARE_VERSION", content.getString("SOFTWARE_VERSION"));
                }
                switch (status = jo.getString("status")) {
                    case "success": {
                        gui.update_box_status(id, "online");
                        break;
                    }
                    case "error": {
                        gui.update_box_status(id, "offline");
                    }
                }
            }
        });
        this.socket.on("get_hubstatus_callback", args -> {
            Object obj = args[0];
            JSONObject jo = (JSONObject)obj;
            if (jo.has("sessiondata")) {
                JSONObject jo2;
                JSONObject session = jo.getJSONObject("sessiondata");
                String hubbox_id = session.getString("hubbox_id");
                String id = session.getString("id");
                if (jo.has("content") && (jo2 = jo.getJSONObject("content")).has("hub_status")) {
                    String status;
                    switch (status = jo2.getJSONObject("hub_status").getString("status")) {
                        case "success": {
                            gui.update_box_hubstatus(id, "Connected");
                            break;
                        }
                        case "error": {
                            gui.update_box_hubstatus(id, "Disconnected");
                        }
                    }
                }
            }
        });
        this.socket.on("cascade_status_callback", args -> {
            Object obj = args[0];
            JSONObject jo = (JSONObject)obj;
            System.out.println("cascade_status_callback");
            System.out.println(jo);
        });
        this.socket.on("connect_after_box", args -> {
            Object obj = args[0];
            JSONObject jo = (JSONObject)obj;
            if (jo.has("content")) {
                String content = (String)jo.get("content");
                try {
                    String status;
                    JsonObject cjson = JsonParser.parseString(content).getAsJsonObject();
                    JSONObject session = jo.getJSONObject("sessiondata");
                    String hubbox_id = session.getString("hubbox_id");
                    String id = session.getString("id");
                    String hubid = session.getString("hubid");
                    switch (status = cjson.get("status").getAsString()) {
                        case "error": {
                            gui.set_hub_is_ready(false, hubid);
                            break;
                        }
                        case "success": {
                            gui.set_hub_is_ready(true, hubid);
                        }
                    }
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
        });
        this.socket.on("remoteusb_ft_status_callback", args -> {
            Object obj = args[0];
            JSONObject jo = (JSONObject)obj;
            if (jo.has("sessiondata")) {
                JSONObject usbstatus;
                JSONObject content;
                JSONObject session = jo.getJSONObject("sessiondata");
                String hubbox_id = session.getString("hubbox_id");
                String id = session.getString("id");
                if (jo.has("content") && (content = jo.getJSONObject("content")).has("usbft_status") && (usbstatus = content.getJSONObject("usbft_status")).has("service_status")) {
                    gui.update_box_usbstatus(id, hubbox_id, usbstatus);
                }
            }
        });
        this.socket.on("remoteusb_ft_start_callback", args -> {
            Object obj = args[0];
            JSONObject jo = (JSONObject)obj;
            if (jo.has("sessiondata")) {
                JSONObject session = jo.getJSONObject("sessiondata");
                String hubbox_id = session.getString("hubbox_id");
                String id = session.getString("id");
                String username = session.getString("user");
                String bus = (String)jo.query("/content/usbft_start_result/busid");
                FabulaDesktopHelper.add_connection(hubbox_id, (JSONObject)jo.query("/content/usbft_start_result/mpf"), bus);
            }
        });
        this.socket.on("remoteusb_ft_stop_callback", args -> {
            Object obj = args[0];
            JSONObject jo = (JSONObject)obj;
        });
        this.socket.on("port_forward_add_callback", args -> {
            Object obj = args[0];
            JSONObject jo = (JSONObject)obj;
            int allocated_port = -1;
            if (jo.has("sessiondata")) {
                JSONObject content;
                JSONObject session = jo.getJSONObject("sessiondata");
                String id = session.getString("id");
                String fakeid = session.getString("fakeid");
                String boxname = session.getString("boxname");
                int local_port = session.getInt("local_port");
                String lan_host_ip = session.getString("lan_host_ip");
                int lan_host_port = session.getInt("lan_host_port");
                if (jo.has("content") && (content = jo.getJSONObject("content")).has("allocated_port")) {
                    allocated_port = content.getInt("allocated_port");
                }
                if (allocated_port == -1) {
                    gui.log_portforward("allocated port is missing", false);
                } else {
                    try {
                        Port_Helper.addLocalPortForward("clientport", "clientport...hubbox", "usb.hubbox.io", 22, "127.0.0.1", local_port, "127.0.0.1", allocated_port);
                        LinkedHashMap<String, Object> lhm = new LinkedHashMap<String, Object>();
                        lhm.put("hubboxid", id);
                        lhm.put("fakeid", fakeid);
                        lhm.put("boxname", boxname);
                        lhm.put("hubbox_lan_host_ip", lan_host_ip);
                        lhm.put("hubbox_lan_host_port", lan_host_port);
                        lhm.put("local_port", local_port);
                        Port_Helper.forwards.add(lhm);
                        String all = "";
                        for (LinkedHashMap<String, Object> forward : Port_Helper.forwards) {
                            all = all + forward.get("local_port") + " -> " + forward.get("boxname") + " -> " + forward.get("hubbox_lan_host_ip") + ":" + forward.get("hubbox_lan_host_port") + System.lineSeparator();
                        }
                        gui.log_portforward(all, true);
                    }
                    catch (JSchException ex) {
                        Logger.getLogger(SocketIO_Desktop_Client.class.getName()).log(Level.SEVERE, null, ex);
                        gui.log_portforward(ex.getMessage(), false);
                    }
                }
            }
        });
    }

    public boolean isConnected() {
        return this.socket.connected();
    }

    public boolean send(Object s2) {
        if (this.socket.connected()) {
            this.socket.emit("toClient", s2);
            return true;
        }
        return false;
    }
}

