/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.helper;

import org.mindrot.jbcrypt.BCrypt;

public class PasswordHelper {
    private static int workload = 11;

    public static String hashPassword(String password_plaintext) {
        String salt = BCrypt.gensalt(workload);
        String hashed_password = BCrypt.hashpw(password_plaintext, salt);
        return hashed_password;
    }

    public static String hashPassword(String password_plaintext, int zorluk) {
        String salt = BCrypt.gensalt(zorluk);
        String hashed_password = BCrypt.hashpw(password_plaintext, salt);
        return hashed_password;
    }

    public static boolean checkPassword(String password_plaintext, String stored_hash) {
        boolean password_verified = false;
        if (null == stored_hash || !stored_hash.startsWith("$2a$")) {
            return false;
        }
        password_verified = BCrypt.checkpw(password_plaintext, stored_hash);
        return password_verified;
    }

    public static void main(String[] args) {
        long t1 = System.currentTimeMillis();
        boolean authenticate = PasswordHelper.checkPassword("hubbox", "$2a$12$P546/KpzvXaLgBmVH0hK9.5.Roge.ddv5Vf88e57G3QgyBAVBO4Bu");
        long fark = System.currentTimeMillis() - t1;
        System.out.println(fark + " ms " + authenticate);
    }
}

