/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.helper;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;

public class Konsol_Helper {
    public static String vpncmd_exe_path;
    public static String driverinstaller_exe_path;

    public static void clear_cons() {
        try {
            ArrayList<HashMap<String, String>> connectionSettings = Konsol_Helper.getConnectionSettings();
            if (connectionSettings != null) {
                for (HashMap<String, String> local_con : connectionSettings) {
                    String alias_live = local_con.get("VPN Connection Setting Name");
                    Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountDelete", alias_live);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Konsol_Helper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Konsol_Helper(String exe_path) {
        vpncmd_exe_path = exe_path;
    }

    public static void main(String[] args) {
    }

    public static boolean setPassword() throws IOException {
        String sonuc = Konsol_Helper.run_cmd_process(5, vpncmd_exe_path, "localhost", "/client", "/CSV", "/CMD", "passwordset", "hubbox.hubbox");
        return sonuc.contains("Connected to VPN Client");
    }

    public static boolean isPasswordSet() throws IOException {
        String s1 = Konsol_Helper.run_cmd_process(5, vpncmd_exe_path, "localhost", "/client");
        return s1.endsWith("Password: ");
    }

    public static ArrayList<HashMap<String, String>> getVirtualNetwork_Adapters() {
        String text = Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "NicList");
        text = text.substring(text.indexOf("Virtual Network Adapter Name,Status,MAC Address,Version"));
        ArrayList<HashMap<String, String>> adapters = Konsol_Helper.key_value_map_list(text);
        adapters.sort(new Comparator<HashMap<String, String>>(){

            @Override
            public int compare(HashMap<String, String> o1, HashMap<String, String> o2) {
                return o1.get("Virtual Network Adapter Name").compareTo(o2.get("Virtual Network Adapter Name"));
            }
        });
        return adapters;
    }

    public static boolean isNicCreated() throws IOException {
        ArrayList<HashMap<String, String>> vnas = Konsol_Helper.getVirtualNetwork_Adapters();
        for (HashMap<String, String> vna : vnas) {
            if (!vna.get("Virtual Network Adapter Name").equals("VPN99")) continue;
            return true;
        }
        return false;
    }

    public static void createNic(String name) {
        String create_result = Konsol_Helper.run_cmd_process3(driverinstaller_exe_path, "instvlan", name);
    }

    public static void deleteNic(String name) {
        Konsol_Helper.run_cmd_process(120, vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "NicDelete", name);
    }

    public static void enableNic(String name) {
        Konsol_Helper.run_cmd_process(120, vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "NicEnable", name);
    }

    public static void disableNic(String name) {
        Konsol_Helper.run_cmd_process(120, vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "NicDisable", name);
    }

    public static ArrayList<HashMap<String, String>> getConnectionSettings() throws IOException {
        if (vpncmd_exe_path == null) {
            return null;
        }
        String text = Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountList");
        if (text.contains("VPN Connection Setting Name")) {
            text = text.substring(text.indexOf("VPN Connection Setting Name,Status,VPN Server Hostname,Virtual Hub,Virtual Network Adapter Name"));
            ArrayList<HashMap<String, String>> connection_settings = Konsol_Helper.key_value_map_list(text);
            return connection_settings;
        }
        return null;
    }

    public static boolean isConnectionSettingCreated() throws IOException {
        ArrayList<HashMap<String, String>> connectionSettings = Konsol_Helper.getConnectionSettings();
        for (HashMap<String, String> cs : connectionSettings) {
            if (!cs.get("VPN Connection Setting Name").equals("hubbox")) continue;
            return true;
        }
        return false;
    }

    public static boolean createConnectionSetting(String alias, String server, String port, String hub, String username, String password, String adapter) throws IOException {
        String out1 = Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CMD", "AccountDelete", alias);
        String out2 = Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountCreate", alias, "/SERVER:" + server + ":" + port, "/HUB:" + hub, "/USERNAME:" + username, "/NICNAME:" + adapter);
        String out3 = Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountPasswordSet", alias, "/PASSWORD:" + password, "/TYPE:standard");
        Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountStatusHide", alias);
        return true;
    }

    public static boolean setAccount(String server, String hub) throws IOException {
        Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountSet", "hubbox", "/SERVER:" + server, "/HUB:" + hub);
        return true;
    }

    public static boolean setAccountUsername(String user) throws IOException {
        Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountUsernameSet", "hubbox", "/USERNAME:" + user);
        return true;
    }

    public static boolean setAccountPassword(String password) throws IOException {
        Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountPasswordSet", "hubbox", "/PASSWORD:" + password);
        return true;
    }

    public static String connect(String alias) throws IOException {
        return Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountConnect", alias);
    }

    public static void disconnect(String alias) throws IOException {
        Konsol_Helper.run_cmd_process(vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "AccountDisconnect", alias);
    }

    public static String getStatus() throws IOException {
        String s1 = Konsol_Helper.run_cmd_process(3, vpncmd_exe_path, "localhost", "/client", "/password:hubbox.hubbox", "/CSV", "/CMD", "accountstatusget", "hubbox");
        return s1;
    }

    public static String se_key_value(String text, String key) {
        String[] lines;
        for (String line : lines = text.split(Pattern.quote("\n"))) {
            if (!line.startsWith(key)) continue;
            return line.substring(line.indexOf("|") + 1);
        }
        return null;
    }

    public static HashMap<String, String> key_value_map(String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] lines = text.split(Pattern.quote("\n"));
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] values = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                values[j] = value;
            }
            if (line.startsWith("---")) continue;
            if (values.length == 1) {
                map.put(values[0], "");
                continue;
            }
            map.put(values[0], values[1]);
        }
        return map;
    }

    public static String netsh_key_value(String text, String key) {
        String[] lines;
        for (String line : lines = text.split(Pattern.quote("\n"))) {
            if (!line.startsWith(key)) continue;
            String s1 = line.substring(line.indexOf(":") + 1);
            s1 = s1.trim();
            return s1;
        }
        return null;
    }

    public static ArrayList<HashMap<String, String>> key_value_map_list(String text) {
        ArrayList<HashMap<String, String>> liste = new ArrayList<HashMap<String, String>>();
        String[] lines = text.split(Pattern.quote("\n"));
        String[] titles = lines[0].split(",");
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] values = line.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                values[j] = value;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (int j = 0; j < titles.length; ++j) {
                String title = titles[j];
                String value = values[j];
                map.put(title, value);
            }
            liste.add(map);
        }
        return liste;
    }

    public static void setExePath(String s2) {
        vpncmd_exe_path = s2;
    }

    public static String getNetwork() {
        String adapter = "VPN99 - VPN Client";
        return Konsol_Helper.run_cmd_process("netsh", "interface", "ip", "show", "config", "name=", adapter);
    }

    public static String run_cmd_process(String ... cmd4) {
        return Konsol_Helper.run_cmd_process(60, cmd4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String run_cmd_process(int seconds, String ... cmd4) {
        String sonuc = "";
        Process process = null;
        try {
            String s2;
            String os = System.getProperty("os.name");
            ProcessBuilder pb = new ProcessBuilder(cmd4);
            pb.redirectErrorStream(true);
            process = pb.start();
            InputStream inputStream = process.getInputStream();
            sonuc = s2 = Konsol_Helper.readInputStreamWithTimeout(inputStream, seconds * 1000);
            if (sonuc.endsWith(System.lineSeparator())) {
                sonuc = sonuc.trim();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Konsol_Helper.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return sonuc;
    }

    public static String readInputStreamWithTimeout(final InputStream is, final int timeoutMillis) throws IOException {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        StringBuilder sb = new StringBuilder();
        final ArrayList result2 = new ArrayList();
        Callable<String> readTask = new Callable<String>(){

            @Override
            public String call() throws Exception {
                StringBuilder sb = new StringBuilder();
                InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                long t1 = System.currentTimeMillis();
                try {
                    int read;
                    while ((read = isr.read()) != -1) {
                        char ch = (char)read;
                        sb.append(ch);
                        result2.add(Character.valueOf(ch));
                        if (!(ch != ' ' ? ch == '>' && sb.toString().endsWith("\nVPN Client>") : sb.toString().endsWith("\nPassword: "))) {
                            if (System.currentTimeMillis() - t1 <= (long)timeoutMillis) continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return sb.toString();
            }
        };
        Future<String> future = executor.submit(readTask);
        String result = null;
        try {
            result = future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (result == null) {
            StringBuilder sb2 = new StringBuilder();
            for (Character character : result2) {
                sb2.append(character);
            }
            result = sb2.toString();
        }
        boolean cancel = future.cancel(true);
        executor.shutdownNow();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String run_cmd_process2(String cmd) {
        String sonuc = "";
        Process process = null;
        try {
            ProcessBuilder pb = null;
            pb = new ProcessBuilder(cmd.split(" "));
            pb.redirectErrorStream(true);
            process = pb.start();
            StringBuilder out = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            String previous = null;
            while ((line = br.readLine()) != null) {
                if (line.equals(previous)) continue;
                previous = line;
                out.append(line);
                out.append(System.lineSeparator());
            }
            boolean waitFor = process.waitFor(60L, TimeUnit.SECONDS);
            sonuc = out.toString();
            if (sonuc.endsWith(System.lineSeparator())) {
                sonuc = sonuc.trim();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Konsol_Helper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Konsol_Helper.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return sonuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String run_cmd_process3(String ... cmd) {
        String sonuc = "";
        Process process = null;
        try {
            ProcessBuilder pb = null;
            pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            process = pb.start();
            StringBuilder out = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            String previous = null;
            while ((line = br.readLine()) != null) {
                if (line.equals(previous)) continue;
                previous = line;
                out.append(line);
                out.append(System.lineSeparator());
            }
            boolean waitFor = process.waitFor(60L, TimeUnit.SECONDS);
            sonuc = out.toString();
            if (sonuc.endsWith(System.lineSeparator())) {
                sonuc = sonuc.trim();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Konsol_Helper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Konsol_Helper.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return sonuc;
    }

    public static Object[] run_cmd_process_timeout_parsed(int seconds, String ... cmd) {
        CommandLine cmdLine = new CommandLine(cmd[0]);
        for (int i = 1; i < cmd.length; ++i) {
            cmdLine.addArgument(cmd[i], false);
        }
        DefaultExecutor executor = new DefaultExecutor();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler(outputStream);
        executor.setStreamHandler(streamHandler);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(seconds * 1000);
        executor.setWatchdog(watchdog);
        int my_exitValue = 0;
        int real_exitValue = 0;
        try {
            real_exitValue = executor.execute(cmdLine);
            my_exitValue = 1;
        }
        catch (ExecuteException ex2) {
            real_exitValue = ex2.getExitValue();
            my_exitValue = -1;
        }
        catch (IOException ex) {
            my_exitValue = -1;
        }
        return new Object[]{my_exitValue, outputStream.toString(), real_exitValue};
    }

    static class Connection_Setting {
        String name;
        String status;
        String server_hostname;
        String hub;
        String adapter;

        Connection_Setting() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getServer_hostname() {
            return this.server_hostname;
        }

        public void setServer_hostname(String server_hostname) {
            this.server_hostname = server_hostname;
        }

        public String getHub() {
            return this.hub;
        }

        public void setHub(String hub) {
            this.hub = hub;
        }

        public String getAdapter() {
            return this.adapter;
        }

        public void setAdapter(String adapter) {
            this.adapter = adapter;
        }
    }

    static class Virtual_Network_Adapter {
        String name;
        String status;
        String MAC;
        String version;

        Virtual_Network_Adapter() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getMAC() {
            return this.MAC;
        }

        public void setMAC(String MAC2) {
            this.MAC = MAC2;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

