/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.helper;

import com.jcraft.jsch.JSchException;
import io.hubbox.hubbox_desktop_client2.MainFrame_box_usbft;
import io.hubbox.hubbox_desktop_client2.helper.Konsol_Helper;
import io.hubbox.hubbox_desktop_client2.helper.PathHelper;
import io.hubbox.hubbox_desktop_client2.helper.port.Port_Helper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public class FabulaDesktopHelper {
    static List<Map<String, Object>> forwards = new ArrayList<Map<String, Object>>();
    static final String path = PathHelper.getPath();
    private static final Logger logger = Logger.getLogger(FabulaDesktopHelper.class.getName());

    public static void add_connection(String hubbox_id, JSONObject mpf, String bus) {
        try {
            int local_port = Port_Helper.addLocalPortForward("clientport", "clientport...hubbox", mpf.getString("ip"), 22, null, 0, "localhost", mpf.getInt("rport"));
            logger.info("--localport = " + local_port);
            logger.info("--bus = " + bus);
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("hubbox_id", hubbox_id);
            hm.put("localport", local_port);
            forwards.add(hm);
            Object[] sonuc = Konsol_Helper.run_cmd_process_timeout_parsed(10, FabulaDesktopHelper.get_usb_config_path() + File.separator + "usbclncmd.exe", "add", "-a", "127.0.0.1", local_port + "", "-P", "hub");
            logger.info("usbclncmd.exe result " + sonuc[1]);
        }
        catch (JSchException ex) {
            Logger.getLogger(FabulaDesktopHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void remove_connection(String hubbox_id) {
        Object[] sonuc = Konsol_Helper.run_cmd_process_timeout_parsed(3, FabulaDesktopHelper.get_usb_config_path() + File.separator + "usbclncmd.exe", "list", "-D");
        String s2 = (String)sonuc[1];
        String s1 = "srvID:";
        String s22 = "127.0.0.1:";
        HashMap<Integer, String> hm = new HashMap<Integer, String>();
        String[] lines = s2.split("[\\r?\\n]+");
        for (String line : lines) {
            if ((line = line.trim()).equals("---Discovered servers---")) break;
            if (!line.startsWith(s1)) continue;
            int i1 = line.indexOf(s1);
            String id = line.substring(i1 + s1.length(), line.indexOf(" ", i1 + s1.length()));
            int i2 = line.indexOf(s22);
            Integer port = new Integer(line.substring(i2 + s22.length(), line.indexOf(" ", i2 + s22.length())));
            hm.put(port, id);
        }
        for (Map map : forwards) {
            Integer lport;
            String hid = (String)map.get("hubbox_id");
            if (!hid.equals(hubbox_id) || !hm.containsKey(lport = (Integer)map.get("localport"))) continue;
            Konsol_Helper.run_cmd_process_timeout_parsed(3, FabulaDesktopHelper.get_usb_config_path() + File.separator + "usbclncmd.exe", "del", (String)hm.get(lport));
        }
    }

    private static String get_usb_config_path() {
        return new File(path + File.separator + "extra", "usb").getPath();
    }

    public static void checkInstall(MainFrame_box_usbft anaframe) {
        File file = new File(FabulaDesktopHelper.get_usb_config_path() + File.separator + "usbclncmd.exe");
        File file2 = new File(FabulaDesktopHelper.get_usb_config_path() + File.separator + "usb-over-network-64bit.msi");
        boolean b1 = file.exists();
        logger.info("usbclient exists1 ? " + b1 + " " + file2.exists());
        if (!b1) {
            boolean b2 = file2.exists();
            if (b2) {
                logger.info("usbclncmd yok msi var");
                String batfile = "msiexec /i usb-over-network-64bit.msi /qn INSTALLLOCATION=\"" + FabulaDesktopHelper.get_usb_config_path() + "\" ADDLOCAL=Drivers_cln_f,User_cln_f ADDSOURCE=Drivers_cln_f,User_cln_f INSTALLDESKTOPSHORTCUTS=\"\" OPEN_URL=0 ";
                try {
                    FileUtils.writeStringToFile(new File(FabulaDesktopHelper.get_usb_config_path() + File.separator + "install.bat"), batfile, StandardCharsets.UTF_8);
                }
                catch (IOException ex) {
                    Logger.getLogger(FabulaDesktopHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
                CommandLine cmdLine = new CommandLine("cmd");
                cmdLine.addArgument("/c");
                cmdLine.addArgument(FabulaDesktopHelper.get_usb_config_path() + File.separator + "install.bat");
                DefaultExecutor executor = new DefaultExecutor();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                PumpStreamHandler streamHandler = new PumpStreamHandler(outputStream);
                executor.setStreamHandler(streamHandler);
                executor.setWorkingDirectory(new File(FabulaDesktopHelper.get_usb_config_path()));
                try {
                    executor.execute(cmdLine);
                }
                catch (IOException ex) {
                    Logger.getLogger(FabulaDesktopHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
                File f1 = new File(FabulaDesktopHelper.get_usb_config_path() + File.separator + "License.rtf");
                File f2 = new File(FabulaDesktopHelper.get_usb_config_path() + File.separator + "usbclient.exe");
                File f3 = new File(FabulaDesktopHelper.get_usb_config_path() + File.separator + "usbclienthelp.chm");
                File f4 = new File(FabulaDesktopHelper.get_usb_config_path() + File.separator + "usb-over-network-64bit.msi");
                File f5 = new File(FabulaDesktopHelper.get_usb_config_path() + File.separator + "install.bat");
                f1.delete();
                f2.delete();
                f3.delete();
                f5.delete();
            } else {
                anaframe.addCheckLog("USB driver is missing");
                logger.info("USB driver is missing");
            }
        }
        b1 = file.exists();
        logger.info("usbclient exists2 ? " + b1);
        if (!b1) {
            Object[] options = new String[]{"Yes", "No"};
            int response = JOptionPane.showOptionDialog(null, "Usb driver installation needs to restart your computer\nPlease save your work\nWould you like to continue ?", "Confirm to reboot", -1, -1, null, options, options[0]);
            switch (response) {
                case 0: {
                    Konsol_Helper.run_cmd_process3("cmd", "/c", "msiexec", "/x", file2.getAbsolutePath(), "OPEN_URL=0", "/qn");
                    break;
                }
            }
        }
    }
}

