/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.helper;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public class DiscoverClient {
    public LinkedBlockingQueue<HashMap<String, String>> bulunanlar;
    public boolean finished = false;
    private static final Logger logger = Logger.getLogger(DiscoverClient.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedBlockingQueue<HashMap<String, String>> scan() {
        this.bulunanlar = new LinkedBlockingQueue();
        try (DatagramSocket c = null;){
            c = new DatagramSocket();
            c.setBroadcast(true);
            byte[] sendData = "DISCOVER_HUBBOXSERVER_REQUEST".getBytes();
            JsonObject jo = new JsonObject();
            jo.addProperty("title", "DISCOVER_HUBBOXSERVER_REQUEST");
            byte[] sendData2 = jo.toString().getBytes();
            try {
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, InetAddress.getByName("255.255.255.255"), 8888);
                c.send(sendPacket);
                DatagramPacket sendPacket2 = new DatagramPacket(sendData2, sendData2.length, InetAddress.getByName("255.255.255.255"), 8888);
                c.send(sendPacket2);
            }
            catch (Exception sendPacket) {
                // empty catch block
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress broadcast = interfaceAddress.getBroadcast();
                    if (broadcast == null) continue;
                    logger.info("sending broadcast to " + broadcast.getHostAddress());
                    try {
                        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, broadcast, 8888);
                        c.send(sendPacket);
                        DatagramPacket sendPacket2 = new DatagramPacket(sendData2, sendData2.length, broadcast, 8888);
                        c.send(sendPacket2);
                    }
                    catch (Exception sendPacket) {}
                }
            }
            c.setSoTimeout(30000);
            long start = System.currentTimeMillis();
            while (true) {
                DatagramPacket receivePacket;
                block15: {
                    byte[] recvBuf = new byte[15000];
                    receivePacket = new DatagramPacket(recvBuf, recvBuf.length);
                    try {
                        c.receive(receivePacket);
                    }
                    catch (SocketTimeoutException ex) {
                        if (System.currentTimeMillis() - start <= 30000L) break block15;
                        break;
                    }
                }
                String message = new String(receivePacket.getData()).trim();
                if (message.startsWith("DISCOVER_HUBBOXSERVER_RESPONSE")) {
                    HashMap<String, String> device = new HashMap<String, String>();
                    device.put("ip", receivePacket.getAddress().toString());
                    device.put("model", message.substring(1 + message.lastIndexOf("_")));
                    this.bulunanlar.add(device);
                    continue;
                }
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                Map m3 = (Map)new Gson().fromJson(message, type);
                HashMap<String, String> device = new HashMap<String, String>();
                device.put("ip", receivePacket.getAddress().toString());
                device.put("model", (String)m3.get("model"));
                device.put("serial", (String)m3.get("serial"));
                device.put("version", (String)m3.get("version"));
                this.bulunanlar.add(device);
            }
        }
        this.finished = true;
        return this.bulunanlar;
    }

    public static void main(String[] args) {
        DiscoverClient discoverClient = new DiscoverClient();
        LinkedBlockingQueue<HashMap<String, String>> devices = discoverClient.scan();
        for (HashMap<String, String> device : devices) {
            System.out.println(device.get("ip"));
        }
    }
}

