/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.hubbox_desktop_client2.discover;

import io.hubbox.hubbox_desktop_client2.helper.DiscoverClient;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.JXTable;

public class Discover_Frame
extends JFrame {
    private HashSet<String> unique_ips;
    private JScrollPane jScrollPane2;
    private JXTable jXTable1;
    private JButton scan_button;

    public Discover_Frame() {
        this.initComponents();
        this.unique_ips = new HashSet();
        this.scan();
    }

    private void updateRowHeights() {
        for (int row = 0; row < this.jXTable1.getRowCount(); ++row) {
            int rowHeight = this.jXTable1.getRowHeight();
            for (int column = 0; column < this.jXTable1.getColumnCount(); ++column) {
                Component comp = this.jXTable1.prepareRenderer(this.jXTable1.getCellRenderer(row, column), row, column);
                rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
            }
            this.jXTable1.setRowHeight(row, rowHeight);
        }
    }

    private void initComponents() {
        this.scan_button = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jXTable1 = new JXTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hubbox Discovery");
        this.scan_button.setFont(new Font("Segoe UI Semibold", 0, 14));
        this.scan_button.setText("Scan");
        this.scan_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Discover_Frame.this.scan_buttonActionPerformed(evt);
            }
        });
        this.jXTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"IP", "Model", "Serial", "Version"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jXTable1.setEditable(false);
        this.jXTable1.setFont(new Font("Segoe UI Light", 0, 14));
        this.jScrollPane2.setViewportView(this.jXTable1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 453, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.scan_button).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scan_button).addContainerGap()));
        this.pack();
    }

    private void scan_buttonActionPerformed(ActionEvent evt) {
        this.scan();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Discover_Frame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Discover_Frame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Discover_Frame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Discover_Frame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Discover_Frame().setVisible(true);
            }
        });
    }

    private void scan() {
        DefaultTableModel dtm = (DefaultTableModel)this.jXTable1.getModel();
        dtm.setRowCount(0);
        new Thread(new Runnable(){

            @Override
            public void run() {
                final DiscoverClient dc = new DiscoverClient();
                Discover_Frame.this.unique_ips.clear();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Discover_Frame.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        do {
                            try {
                                HashMap<String, String> device = dc.bulunanlar.poll(30L, TimeUnit.SECONDS);
                                if (device == null) continue;
                                String ip = device.get("ip");
                                String model = device.get("model");
                                String serial = device.get("serial");
                                String version = device.get("version");
                                if (ip.startsWith("/")) {
                                    ip = ip.substring(1);
                                }
                                if (Discover_Frame.this.unique_ips.contains(ip)) continue;
                                Discover_Frame.this.unique_ips.add(ip);
                                DefaultTableModel dtm = (DefaultTableModel)Discover_Frame.this.jXTable1.getModel();
                                dtm.addRow(new Object[]{ip, model, serial, version});
                                Discover_Frame.this.updateRowHeights();
                                Discover_Frame.this.jXTable1.packAll();
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Discover_Frame.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        } while (!dc.finished);
                    }
                }).start();
                dc.scan();
            }
        }).start();
    }
}

